/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.persist.impl;

import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.persist.GenericPersistence;
import com.ibm.hwmca.fw.service.persist.PersistentObjectControl;
import com.ibm.hwmca.fw.service.persist.PersistentObjectDescriptor;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GenericPersistenceImpl
implements GenericPersistence {
    private static final String TRACE_MASKT = "XRVF061T";
    private static final String TRACE_MASKF = "XRVF061F";
    private static final String TRACE_MASKD = "XRVF061D";
    private String parentKey;
    private String mapKey;
    private PersistenceManager persistenceManager;
    private PersistentObjectControl persistentObjectControl = null;
    private Object lockObject = new Object();
    private PersistableMap keyMap = null;

    public GenericPersistenceImpl(String parentKey) {
        this(parentKey, null);
        Trace.trace(TRACE_MASKT, "<> GenericPersistenceImpl default ctor, parentKey[" + parentKey + "]");
    }

    public GenericPersistenceImpl(String parentKey, PersistentObjectControl persistentObjectControl) {
        Trace.trace(TRACE_MASKT, "<> GenericPersistenceImpl ctor, parentKey[" + parentKey + "],PersistentObjectControl[" + persistentObjectControl + "]");
        this.parentKey = parentKey;
        this.mapKey = parentKey + ".map";
        this.persistentObjectControl = persistentObjectControl;
        this.persistenceManager = PersistenceManager.getPersistenceManager();
        try {
            this.loadMap();
        }
        catch (PersistenceException e) {
            Trace.trace(TRACE_MASKF, "<-! GenericPersistenceImpl ctor, exception thrown/caught/eaten loading map");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String uniqueId, Persistable persistable) throws PersistenceException {
        Trace.trace(TRACE_MASKT, "-> GenericPersistenceImpl.store( uniqueId[" + uniqueId + "])");
        if (this.keyMap.containsKey(uniqueId)) {
            this.persistenceManager.write(((PersistentObjectDescriptor)this.keyMap.get((Object)uniqueId)).persistentId, persistable);
        } else {
            PersistentObjectDescriptor pod;
            String persistentId = this.persistenceManager.writeChild(this.parentKey, persistable);
            Object object = this.lockObject;
            synchronized (object) {
                pod = this.persistentObjectControl != null ? this.persistentObjectControl.createObjectDescriptor(persistentId, persistable) : new PersistentObjectDescriptor(persistentId);
            }
            this.keyMap.put(uniqueId, pod);
            this.storeMap();
        }
        Trace.trace(TRACE_MASKT, "<- GenericPersistenceImpl.store( uniqueId[" + uniqueId + "])");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistable load(String uniqueId) throws PersistenceException {
        Trace.trace(TRACE_MASKT, "-> GenericPersistenceImpl.load(uniqueId[" + uniqueId + "])");
        Persistable persistable = null;
        if (this.keyMap.size() > 0) {
            Object object = this.lockObject;
            synchronized (object) {
                if (this.persistentObjectControl != null) {
                    this.persistentObjectControl.filter(this, (Map)this.keyMap.clone(), uniqueId);
                }
            }
            if (this.keyMap.containsKey(uniqueId)) {
                try {
                    persistable = (Persistable)this.persistenceManager.read(((PersistentObjectDescriptor)this.keyMap.get((Object)uniqueId)).persistentId);
                    if (persistable == null) {
                        Trace.trace(TRACE_MASKT, "GenericPersistenceImpl.load, peristed object:" + ((PersistentObjectDescriptor)this.keyMap.get((Object)uniqueId)).persistentId + " for unique id: " + uniqueId + "NOT FOUND!");
                        Trace.trace(TRACE_MASKT, "GenericPersistenceImpl.load ...removing unique id (" + uniqueId + " from persistence map");
                        this.keyMap.remove(uniqueId);
                        this.storeMap();
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, e);
                    Trace.trace(TRACE_MASKT, "GenericPersistenceImpl.load(" + uniqueId + "), Exception caught loading persistence id: " + ((PersistentObjectDescriptor)this.keyMap.get((Object)uniqueId)).persistentId);
                    Trace.trace(TRACE_MASKT, "GenericPersistenceImpl.load ...removing unique id (" + uniqueId + " from persistence map");
                    persistable = null;
                    this.keyMap.remove(uniqueId);
                    this.storeMap();
                }
            } else {
                throw new PersistenceException("uniqueId[" + uniqueId + "] not found!!!");
            }
        }
        Trace.trace(TRACE_MASKT, "<- GenericPersistenceImpl.load, uniqueId[" + uniqueId + "], persistable[" + persistable + "]");
        return persistable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List load() throws PersistenceException {
        Trace.trace(TRACE_MASKT, "-> GenericPersistenceImpl.load");
        ArrayList<Persistable> list = new ArrayList<Persistable>();
        Object object = this.lockObject;
        synchronized (object) {
            if (this.persistentObjectControl != null && this.keyMap.size() > 0) {
                this.persistentObjectControl.filterAll(this, (Map)this.keyMap.clone());
            }
        }
        if (this.keyMap.size() > 0) {
            Iterator it = ((Map)this.keyMap.clone()).keySet().iterator();
            boolean rewriteMap = false;
            while (it.hasNext()) {
                String key = (String)it.next();
                try {
                    Persistable persistable = (Persistable)this.persistenceManager.read(((PersistentObjectDescriptor)this.keyMap.get((Object)key)).persistentId);
                    if (persistable != null) {
                        list.add(persistable);
                        continue;
                    }
                    Trace.trace(TRACE_MASKT, "GenericPersistenceImpl.load(), peristed object: " + ((PersistentObjectDescriptor)this.keyMap.get((Object)key)).persistentId + " NOT FOUND for key: " + key);
                    Trace.trace(TRACE_MASKT, "GenericPersistenceImpl.load() ...removing key: " + key + " from persistence map");
                    this.keyMap.remove(key);
                    rewriteMap = true;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, e);
                    Trace.trace(TRACE_MASKT, "GenericPersistenceImpl.load, Exception caught loading persistence id: " + ((PersistentObjectDescriptor)this.keyMap.get((Object)key)).persistentId + " for key: " + key);
                    Trace.trace(TRACE_MASKT, "GenericPersistenceImpl.load ...removing key (" + key + " from persistence map");
                    this.keyMap.remove(key);
                    rewriteMap = true;
                }
            }
            if (rewriteMap) {
                this.storeMap();
            }
        }
        Trace.trace(TRACE_MASKT, "<- GenericPersistenceImpl.load; returning list containing[" + list.size() + "] objects");
        return list;
    }

    public void remove(String uniqueId) throws PersistenceException {
        Trace.trace(TRACE_MASKT, "-> GenericPersistenceImpl.remove(uniqueId[" + uniqueId + "])");
        if (this.keyMap.containsKey(uniqueId)) {
            this.persistenceManager.delete(((PersistentObjectDescriptor)this.keyMap.get((Object)uniqueId)).persistentId);
            this.keyMap.remove(uniqueId);
            this.storeMap();
        }
        Trace.trace(TRACE_MASKT, "<- GenericPersistenceImpl.remove(uniqueId[" + uniqueId + "])");
    }

    private void loadMap() throws PersistenceException {
        Trace.trace(TRACE_MASKT, "-> GenericPersistenceImpl.loadMap");
        if (this.keyMap == null) {
            try {
                this.keyMap = (PersistableMap)this.persistenceManager.read(this.mapKey);
                if (this.keyMap == null) {
                    this.keyMap = new PersistableMap();
                }
            }
            catch (PersistenceException pe) {
                this.keyMap = new PersistableMap();
            }
        }
        Trace.trace(TRACE_MASKT, "<- GenericPersistenceImpl.loadMap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistentObjectControl(PersistentObjectControl persistentObjectControl) {
        Object object = this.lockObject;
        synchronized (object) {
            this.persistentObjectControl = persistentObjectControl;
        }
    }

    private void storeMap() throws PersistenceException {
        Trace.trace(TRACE_MASKT, "-> GenericPersistenceImpl.storeMap");
        this.persistenceManager.write(this.mapKey, this.keyMap);
        Trace.trace(TRACE_MASKT, "<- GenericPersistenceImpl.storeMap");
    }

    private static class PersistableMap
    extends HashMap
    implements PersistentData {
        static final long serialVersionUID = 7740086819197195245L;

        private PersistableMap() {
        }
    }
}

